unit Form_SMSReport;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, BusinessSkinForm, StdCtrls, Grids, BaseGrid, AdvGrid, AdvCGrid,
  ComCtrls, bsSkinTabs, bsSkinCtrls, bsSkinBoxCtrls, bsfilectrl, ExtCtrls,
  MMObj, MMBmpLst, MMBmpBtn, MMPanel, MMFill,dateutils, bsSkinShellCtrls;

type
  TFormSMSReport = class(TForm)
    bsBusinessSkinForm1: TbsBusinessSkinForm;
    MMPanelFill1: TMMPanelFill;
    MMBitmapButton1: TMMBitmapButton;
    Bevel1: TBevel;
    StaticText13: TStaticText;
    StaticText1: TStaticText;
    date1: TbsSkinComboBox;
    date2: TbsSkinComboBox;
    StaticText2: TStaticText;
    StaticText3: TStaticText;
    time1: TDateTimePicker;
    time2: TDateTimePicker;
    MMPanelFill2: TMMPanelFill;
    MMPanelFill3: TMMPanelFill;
    reportdate: TbsSkinFileListBox;
    MMPanelFill9: TMMPanelFill;
    Label1: TLabel;
    dateTree: TbsSkinTreeView;
    MMPanelFill4: TMMPanelFill;
    MMPanelFill6: TMMPanelFill;
    Label3: TLabel;
    Memo4: TMemo;
    reportgrid: TAdvColumnGrid;
    Memo1: TMemo;
    Searchgrid1: TAdvColumnGrid;
    Memo2: TMemo;
    PrintDialog1: TPrintDialog;
    savedialog: TbsSkinSaveDialog;
    bsSkinTabSheet1: TbsSkinTabSheet;
    bsSkinTabSheet2: TbsSkinTabSheet;
    bsSkinPanel5: TbsSkinPanel;
    MMPanelFill5: TMMPanelFill;
    addplaylist: TMMBitmapButton;
    MMBitmapButton3: TMMBitmapButton;
    Save: TMMBitmapButton;
    Page1: TbsSkinPageControl;
    Page2: TbsSkinPageControl;
    bsSkinTabSheet3: TbsSkinTabSheet;
    bsSkinTabSheet4: TbsSkinTabSheet;
    analizer: TAdvColumnGrid;
    bsSkinPanel1: TbsSkinPanel;
    MMPanelFill7: TMMPanelFill;
    MMBitmapButton2: TMMBitmapButton;
    MMBitmapButton4: TMMBitmapButton;
    MMBitmapButton5: TMMBitmapButton;
    bsSkinPanel2: TbsSkinPanel;
    MMPanelFill8: TMMPanelFill;
    MMBitmapButton6: TMMBitmapButton;
    MMBitmapButton7: TMMBitmapButton;
    MMBitmapButton8: TMMBitmapButton;
    analizer2: TAdvColumnGrid;
    ComboBox1: TComboBox;
    StaticText4: TStaticText;
    bsSkinComboBox1: TbsSkinComboBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SaveClick(Sender: TObject);
    procedure MMBitmapButton1Click(Sender: TObject);
    procedure dateTreeClick(Sender: TObject);
    procedure Searchgrid1Click(Sender: TObject);
    procedure reportgridClick(Sender: TObject);
    procedure addplaylistClick(Sender: TObject);
    procedure MMBitmapButton3Click(Sender: TObject);
    procedure MMBitmapButton2Click(Sender: TObject);
    procedure MMBitmapButton4Click(Sender: TObject);
    procedure MMBitmapButton5Click(Sender: TObject);
    procedure MMBitmapButton7Click(Sender: TObject);
    procedure MMBitmapButton8Click(Sender: TObject);
    procedure MMBitmapButton6Click(Sender: TObject);
    procedure StaticText4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormSMSReport: TFormSMSReport;

implementation

uses form_mainform, Form_report, Form_stationlist;

{$R *.dfm}

procedure TFormSMSReport.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  width:=0;
  height:=0;
  FormStyle:=fsnormal;
  Visible:=false;
  mainform.AutoArrange1.Click;
end;

procedure TFormSMSReport.SaveClick(Sender: TObject);
var i:integer;
    text:string;
begin
  reportgrid.SaveTofile(workdir+'share\Report\sms\'+datesave+'.rep');
  reportdate.Update;
    formSMSreport.reportdate.Directory:=workdir+'share\Report\sms\';
    formSMSreport.Update;

    formSMSreport.Memo1.Lines.Clear;
    if formSMSreport.reportdate.Items.Count>0 then
    begin
       for i:=0 to formSMSreport.reportdate.Items.Count-1 do
       begin
          text:=copy(formSMSreport.reportdate.Items.Strings[i],1,length(formSMSreport.reportdate.Items.Strings[i])-4);
          insert('/',text,3);
          formSMSreport.Memo1.Lines.Add(text);
       end;

       reportgrid.Columns[3].Alignment:=taLeftJustify;

       formSMSreport.Memo1.Lines.SaveToFile(workdir+'temp');
       formSMSreport.dateTree.ChangeDelay:=100;
       formSMSreport.dateTree.LoadFromFile(workdir+'temp');
       deletefile(workdir+'temp');
    end;
end;


procedure TFormSMSReport.MMBitmapButton1Click(Sender: TObject);
var i,j:integer;
begin
    page1.TabIndex:=0;
    page2.TabIndex:=0;

    searchgrid1.Visible:=true;
    searchgrid1.RowCount:=2;
    for i:= 0 to searchgrid1.ColCount-1 do searchgrid1.Cells[i,1]:='';

    for i:=1 to reportgrid.RowCount-1 do
    begin
      if reportgrid.Cells[2,i]<>'' then
      begin
        //showmessage(inttostr(dayof(strtodate(reportgrid.Cells[2,i]))));
        shortdateformat:='mm/dd/yyyy';
        if (dayof(strtodate(reportgrid.Cells[2,i])) >= date1.ItemIndex+1 ) and
           (dayof(strtodate(reportgrid.Cells[2,i])) <= date2.ItemIndex+1 ) then
        begin
         if  (strtodatetime(datetostr(date)+' '+copy(reportgrid.Cells[1,i],1,length(reportgrid.Cells[1,i])-3)) > strtodatetime(datetostr(date)+' '+timetostr(time1.Time))) and
             (strtodatetime(datetostr(date)+' '+copy(reportgrid.Cells[1,i],1,length(reportgrid.Cells[1,i])-3)) < strtodatetime(datetostr(date)+' '+timetostr(time2.Time))) then
          begin
            if searchgrid1.Cells[0,1]<>'' then searchgrid1.RowCount:=searchgrid1.RowCount+1;
            for j:=0 to reportgrid.colcount-1 do searchgrid1.Cells[j,searchgrid1.RowCount-1]:=reportgrid.Cells[j,i];
          end;
        end;
      end;
    end;
end;


procedure TFormSMSReport.dateTreeClick(Sender: TObject);
var i:integer;
    st_id:string;
begin
  if bsSkinComboBox1.Text='LOCAL STATION' then st_id:=RBO_ID else st_id:=bsSkinComboBox1.Text;
  reportdate.ItemIndex:=datetree.Selected.AbsoluteIndex;
  //if fileexists(reportdate.FileName) then
  begin
    searchgrid1.Visible:=false;
    mainform.clear_grid(reportgrid);
    //reportgrid.LoadFromfile(reportdate.FileName);
    mainform.sms_report.First;
    while not mainform.sms_report.Eof do
    begin
      if (mainform.sms_report.FieldByName('date').AsString=datetree.Selected.Text) and
         (mainform.sms_report.FieldByName('RBO_ID').AsString=st_id) then
      begin
         if reportgrid.Cells[0,1]<>'' then  reportgrid.RowCount:=reportgrid.RowCount+1;
         reportgrid.Cells[0,reportgrid.RowCount-1]:=mainform.sms_report.fieldbyname('froms').AsString;
         reportgrid.Cells[1,reportgrid.RowCount-1]:=mainform.sms_report.fieldbyname('time').AsString;
         reportgrid.Cells[2,reportgrid.RowCount-1]:=mainform.sms_report.fieldbyname('date').AsString;
         reportgrid.Cells[3,reportgrid.RowCount-1]:=mainform.sms_report.fieldbyname('content').AsString;
         reportgrid.Cells[4,reportgrid.RowCount-1]:=mainform.sms_report.fieldbyname('truename').AsString;
         reportgrid.Cells[5,reportgrid.RowCount-1]:=mainform.sms_report.fieldbyname('sts').AsString;
      end;
      mainform.sms_report.Next;
    end;
    reportgrid.Visible:=true;
  end;
  page1.TabIndex:=0;
  page2.TabIndex:=0;
end;

procedure TFormSMSReport.Searchgrid1Click(Sender: TObject);
begin
  if searchgrid1.cells[3,searchgrid1.row]<>'' then memo4.Lines.text:=searchgrid1.cells[3,searchgrid1.row];
end;

procedure TFormSMSReport.reportgridClick(Sender: TObject);
begin
  if reportgrid.cells[3,reportgrid.row]<>'' then memo4.Lines.text:=reportgrid.cells[3,reportgrid.row];
end;

procedure TFormSMSReport.addplaylistClick(Sender: TObject);
begin
  if printdialog1.Execute then
  begin
    if searchgrid1.Visible=false then
    begin
        reportgrid.PrintSettings.TitleText:='SMS report';
        reportgrid.Print;
    end else
    if searchgrid1.Visible=true then
    begin
       searchgrid1.PrintSettings.TitleText:='SMS report';
       searchgrid1.Print;
    end;
  end;
end;

procedure TFormSMSReport.MMBitmapButton3Click(Sender: TObject);
begin
    if searchgrid1.Visible=false then
    begin
      if savedialog.Execute then
      begin
        reportgrid.PrintSettings.TitleText:='Playlist report';
        reportgrid.SaveToXLS(savedialog.FileName);
      end;
    end else
    if searchgrid1.Visible=true then
    begin
      if savedialog.Execute then
      begin
        searchgrid1.PrintSettings.TitleText:='Playlist report';
        searchgrid1.SaveToXLS(savedialog.FileName);
      end;
    end;
end;

procedure TFormSMSReport.MMBitmapButton2Click(Sender: TObject);
var gridcari:tadvcolumngrid;
    i,j:integer;
    cari:string;
    ketemu:boolean;
    total:integer;
begin
  if searchgrid1.Visible=true then gridcari:=searchgrid1 else gridcari:=reportgrid;

  analizer.RowCount:=2;
  for i:=0 to analizer.ColCount-1 do analizer.Cells[i,1]:='';

  for i:=1 to gridcari.RowCount-1 do
  begin
    cari:='';
    if copy(gridcari.Cells[0,i],1,1)='+' then cari:='0'+copy(gridcari.Cells[0,i],4,3) else
       cari:=copy(gridcari.Cells[0,i],1,5);

    if cari<>'' then
    begin
      ketemu:=false;

      for j:=1 to analizer.RowCount-1 do
      if pos(cari,analizer.Cells[1,j])>0 then
      begin
        if analizer.Cells[1,j]<>'' then
           analizer.Cells[2,j]:=inttostr(strtoint(analizer.Cells[2,j])+1);
           total:=total+1;
           ketemu:=true;
           break;
      end;

      if ketemu=false then
      begin
        if analizer.Cells[0,1]<>'' then analizer.RowCount:=analizer.RowCount+1;
        analizer.Cells[0,analizer.RowCount-1]:=inttostr(analizer.RowCount-1);
        analizer.Cells[1,analizer.RowCount-1]:=cari;
        analizer.Cells[2,analizer.RowCount-1]:='1';
        total:=total+1;
      end;
    end;
  end;

  total:=0;
  for i:=1 to analizer.RowCount-1 do
  begin
    if analizer.Cells[2,i]<>'' then total:=total+strtoint(analizer.Cells[2,i]);
  end;

  for i:=1 to analizer.RowCount-1 do
  begin
     analizer.Cells[3,i]:=currtostr((strtoint(analizer.Cells[2,i])/total)*100) +' %';
  end;
end;

procedure TFormSMSReport.MMBitmapButton4Click(Sender: TObject);
begin
  if printdialog1.Execute then
  begin
    analizer.PrintSettings.TitleText:='SMS Analyze report';
    analizer.Print;
  end;
end;

procedure TFormSMSReport.MMBitmapButton5Click(Sender: TObject);
begin
      if savedialog.Execute then
      begin
        analizer.PrintSettings.TitleText:='SMS analyzer report';
        analizer.SaveToXLS(savedialog.FileName);
      end;

end;

procedure TFormSMSReport.MMBitmapButton7Click(Sender: TObject);
begin
  if printdialog1.Execute then
  begin
    analizer2.PrintSettings.TitleText:='SMS Analyze report';
    analizer2.Print;
  end;
end;

procedure TFormSMSReport.MMBitmapButton8Click(Sender: TObject);
begin
      if savedialog.Execute then
      begin
        analizer2.PrintSettings.TitleText:='SMS analyzer report';
        analizer2.SaveToXLS(savedialog.FileName);
      end;
end;

procedure TFormSMSReport.MMBitmapButton6Click(Sender: TObject);
var gridcari:tadvcolumngrid;
    i,j:integer;
    cari:string;
    ketemu:boolean;
    total:integer;
begin
  if searchgrid1.Visible=true then gridcari:=searchgrid1 else gridcari:=reportgrid;

  analizer2.RowCount:=8;
  for j:=1 to 7 do
  begin
    analizer2.Cells[1,j]:='0';
    analizer2.Cells[2,j]:='0 %';
  end;

  analizer2.Cells[0,1]:=longdaynames[1];
  analizer2.Cells[0,2]:=longdaynames[2];
  analizer2.Cells[0,3]:=longdaynames[3];
  analizer2.Cells[0,4]:=longdaynames[4];
  analizer2.Cells[0,5]:=longdaynames[5];
  analizer2.Cells[0,6]:=longdaynames[6];
  analizer2.Cells[0,7]:=longdaynames[7];

  for i:=1 to gridcari.RowCount-1 do
  begin
    shortdateformat:='mm/dd/yyyy';
    if dayofweek(strtodate(gridcari.Cells[2,i]))=1 then j:=1 else
    if dayofweek(strtodate(gridcari.Cells[2,i]))=2 then j:=2 else
    if dayofweek(strtodate(gridcari.Cells[2,i]))=3 then j:=3 else
    if dayofweek(strtodate(gridcari.Cells[2,i]))=4 then j:=4 else
    if dayofweek(strtodate(gridcari.Cells[2,i]))=5 then j:=5 else
    if dayofweek(strtodate(gridcari.Cells[2,i]))=6 then j:=6 else
    if dayofweek(strtodate(gridcari.Cells[2,i]))=7 then j:=7;

    if analizer2.Cells[1,j]='' then analizer2.Cells[1,j]:='1' else
       analizer2.Cells[1,j]:= inttostr(strtoint(analizer2.Cells[1,j])+1);
  end;

  total:=0;
  for i:=1 to analizer2.RowCount-1 do
  begin
    if analizer2.Cells[1,i]<>'' then total:=total+strtoint(analizer2.Cells[1,i]);
  end;

  for i:=1 to analizer2.RowCount-1 do
  begin
     analizer2.Cells[2,i]:=currtostr((strtoint(analizer2.Cells[1,i])/total)*100) +' %';
  end;
end;

procedure TFormSMSReport.StaticText4Click(Sender: TObject);
begin
  form_id.visible:=true;
end;

end.
